# -*- coding: iso-8859-1 -*-

import config.text

class HtmlOutput:

    def __init__(self, out):
        self.out = out
        self.t = None        
        self.longMode = False
    
    def setLongMode(self, template):
        self.t = template
        self.longMode = True
    
    def setShortMode(self, template):
        self.t = template
        self.longMode = False
        
    def begin(self):
        self.lineNum = 1
        self.lines = ''
        
    def end(self, stats):
        if self.longMode:
            content = self.t.SUMMARY % (stats.numLines(),
                                        stats.numError(),
                                        stats.percentageError(),
                                        stats.numWarning(),
                                        stats.percentageWarning(),
                                        stats.percentageBroken())
            if stats.numLines() > 19:
                content += (self.t.STATISTICS 
                            % stats.metricalVariation(20))
        else:
            content = ''
             
        content += self.t.TABLE % self.lines
        self.out.write(self.t.DOC % content)
    
    def lineProcessed(self, line, result):
        if result.numErrors() > 0:
            status = self.t.COL_2_ERR
        elif result.numWarnings() > 0:
            status = self.t.COL_2_WARN
        else:
            status = self.t.COL_2_OK
            
        self.lines += self.t.ROW % (str(self.lineNum), 
                             status,       
                             result.mainType, 
                             self.__printLine(line, result),
                             self.__printComments(line, result))        
        self.lineNum += 1
        
    def __printLine(self, line, result):
        text = line.content
        
        sIndex = 0 # 0-based
        pos = 8 - text.numSyllables() # 0 = 8th syllable from the end
        output = ''
        cpdIndex = 0
        for cpd in text.compoundWords:
            wInCpdIndex = 0
            for w in cpd.words:
                sInWordIndex = 0
                for s in w.syllables:
                    # 1-based
                    if result.syllableHasError(sIndex + 1):
                        syllText = self.t.SYLL_ERR % s.phones
                    else:
                        syllText = s.phones
                    output += syllText
                    
                    FOOT_BOUNDARIES = [1, 3, 5]
                    
                    if sInWordIndex == len(w.syllables) - 1:
                        if wInCpdIndex == len(cpd.words) - 1:
                            if cpdIndex == len(text.compoundWords) - 1:
                                separator = ''
                            else:
                                if pos in FOOT_BOUNDARIES:
                                    separator = ' / '
                                else:
                                    separator = ' '
                        else:    
                            if pos in FOOT_BOUNDARIES:
                                separator = '/'
                            else:
                                separator = '='
                    else:
                        if pos in FOOT_BOUNDARIES:
                            separator = '/'
                        else:
                            separator = '-'
                     
                    output += separator
                    
                    sIndex += 1
                    sInWordIndex += 1
                    pos += 1
                                
                wInCpdIndex += 1
                            
            cpdIndex += 1  
            
        return output
    
    def __printComments(self, line, result):
        comments = self.__printSyllErrors(line, result) \
                + self.__printGeneralErrors(line, result) \
                + self.__printWarnings(line, result) \
                + self.__printNotes(line, result)
        if len (comments) > 0:
            return self.t.COMMENT_LIST % comments
        else:
            return ''
    
    def __printSyllErrors(self, line, result):
        val = ''
        for k, v in result.syllableErrors.iteritems():
            if len(v) > 0:
                val += self.__formatComment(k)
        return val
    
    def __printGeneralErrors(self, line, result):
        val = ''
        for key in result.generalErrors:
            val += self.__formatComment(key)
        return val
    
    def __printWarnings(self, line, result):
        val = ''
        for key in result.warnings:
            val += self.__formatComment(key)
        return val
    
    def __printNotes(self, line, result):
        val = ''
        for key in result.notes:
            val += self.__formatComment(key)
        return val

    def __formatComment(self, key):
        if self.longMode:
            link = ''
            if config.text.link.has_key(key):
                link = config.text.link[key]
            return self.t.COMMENT_ITEM % (config.text.name[key],
                                          link)
        else:
            return self.t.COMMENT_ITEM % config.text.name[key]
