import config.ids

class RawOutput:

    def __init__(self, out):
        self.out = out
        
    def begin(self):
        pass
        
    def end(self, stats):
        pass
    
    def lineProcessed(self, line, result):
        self.out.write(self.__getLineFull(line, result) + '\n')
    
    def __getLineFull(self, line, result):
        output = ''
        
        status = '0'
        if result.numErrors() > 0:
            status = '2'
        elif result.numWarnings() > 0:
            status = '1'        
        output += status + config.lang.colSeparator
        
        output += result.mainType + config.lang.colSeparator
        
        output += result.detailedType + config.lang.colSeparator
        
        output += result.syllableShapes + config.lang.colSeparator
        
        output += str(line) + config.lang.colSeparator
        
        sylErrorItems = []
        for error, syllables in result.syllableErrors.items():
            if len(syllables) > 0:
                sylErrorItems.append(error + '=' 
                        + ','.join([str(i) for i in syllables]))
        output += ';'.join(sylErrorItems)
        output += config.lang.colSeparator

        output += ';'.join(result.generalErrors.keys()
                           + result.warnings.keys())
        output += config.lang.colSeparator
        
        output += result.alliterationTypes
        output += config.lang.colSeparator
        
        if result.syllablesModified:
            output += '1'
        else:
            output += '0'
        output += config.lang.colSeparator
        
        if result.isBroken:
            output += '1'
        else:
            output += '0' 
               
        return output