# -*- coding: iso-8859-1 -*-

import config.text

class TextOutput:

    def __init__(self, out):
        self.out = out
        self.mode = 'full'
    
    def setMode(self, value):
        assert value in ['full', 'summary', 'rawsummary']

        self.mode = value
        
    def begin(self):
        self.lineNum = 1
        
    def end(self, stats):
        if self.mode == 'full':
            return
        
        if self.mode == 'summary':        
            output = config.text.summary % (stats.numLines(),
                    stats.numError(),
                    stats.percentageError(),
                    stats.numWarning(),
                    stats.percentageWarning(),
                    stats.numBroken(),
                    stats.percentageBroken(),
                    stats.numStrongAlliteration(),
                    stats.percentageStrongAlliteration(),
                    stats.numWeakAlliteration(),
                    stats.percentageWeakAlliteration(),
                    stats.metricalVariation(20))
        else:
            output = config.text.rawsummary % (stats.numLines(),
                    stats.numError(),
                    stats.percentageError(),
                    stats.numWarning(),
                    stats.percentageWarning(),
                    stats.numBroken(),
                    stats.percentageBroken(),
                    stats.numAlliteration('A'),
                    stats.percentageAlliteration('A'),
                    stats.numAlliteration('B'),
                    stats.percentageAlliteration('B'),
                    stats.numAlliteration('C'),
                    stats.percentageAlliteration('C'),
                    stats.numAlliteration('D'),
                    stats.percentageAlliteration('D'),
                    stats.numStrongAlliteration(),
                    stats.percentageStrongAlliteration(),
                    stats.numWeakAlliteration(),
                    stats.percentageWeakAlliteration(),
                    stats.metricalVariation(20))
        self.out.write(output)
        
    def lineProcessed(self, line, result):
        if self.mode != 'full':
            return
        
        if result.numErrors() > 0:
            status = config.text.error
        elif result.numWarnings() > 0:
            status = config.text.warning
        else:
            status = config.text.ok
        self.out.write(str(self.lineNum) + ' ' + status + ' ' + str(line) 
                       + '\n')
        
        self.__printSyllErrors(line, result)
        self.__printGeneralErrors(line, result)
        self.__printWarnings(line, result)
        self.__printNotes(line, result)
        
        self.lineNum += 1    
    
    def __printSyllErrors(self, line, result):
        for k, v in result.syllableErrors.iteritems():
            if len(v) > 0:
                syllables = ', '.join(
                    [line.content.getSyllable(x - 1).phones for x in v])
                self.out.write('\t%s (%s)\n' % (config.text.name[k], 
                                                syllables))
                
    def __printGeneralErrors(self, line, result):
        for key in result.generalErrors:
            self.out.write('\t' + config.text.name[key] + '\n')
    
    def __printWarnings(self, line, result):
        for key in result.warnings:
            self.out.write('\t' + config.text.name[key] + '\n')
    
    def __printNotes(self, line, result):
        for key in result.notes:
            self.out.write('\t' + config.text.name[key] + '\n')