# -*- coding: iso-8859-1 -*-

usage = """Kytt: trokeemankeli [-s | -r | -m][-f tiedosto | -i syte]"""

error_many_sources = 'Virhe: sytteen lhteit on annettu enemmn kuin yksi.'
error_many_outputs = 'Virhe: tulostustapoja on annettu enemmn kuin yksi.'

error = 'Virhe'
warning = 'Varoitus'
ok = 'OK'

name = {}
name['short_rising'] = 'Virhe: Lyhyt alkutavu runojalan nousussa.'
name['long_falling'] = 'Virhe: Pitk alkutavu runojalan laskussa.'
name['long_vowel'] = 'Virhe: Pitk vokaali viimeisess tavussa.'
name['monosyllable'] = 'Virhe: Yksitavuinen sana skeen lopussa.'
name['caesura'] = 'Virhe: Nelitavuinen sana tasaskeen keskell (kesuura puuttuu).'
name['too_long'] = 'Virhe: Yli kymmenen tavua.'
name['too_short'] = 'Virhe: Alle kahdeksan tavua.'
name['heavy_beginning_e'] = 'Virhe: Raskas alku 9-tavuisessa skeess: pitk vokaali kolmessa ensimmisess tavussa.'
name['alliteration'] = 'Varoitus: Mahdollisesti liioitteleva alkusointu.'
name['heavy_beginning_w'] = 'Varoitus: Raskas alku 9-tavuisessa skeess: kolme pitk tavua skeen alussa.'
name['nine'] = '(Huom: yhdeksntavuinen.)'
name['ten'] = '(Huom: kymmentavuinen.)'
name['syllabification'] = '(Tavutus epvarma.)'

BASE = '(<a href="http://www.sci.fi/~alboin/cgi-bin/mankelisaanto.pl?n=%d">%s</a>)'

link = {}
link['short_rising'] = BASE % (0, 'Psnt')
link['long_falling'] = BASE % (0, 'Psnt')
link['long_vowel'] = BASE % (4, 'Lissnt 4')
link['monosyllable'] = BASE % (2, 'Lissnt 2')
link['caesura'] = BASE % (3, 'Lissnt 3')

summary = '''Rivej: %d
Tulkittu virheelliseksi: %d (%.1f %%)
Pelkk varoitus: %d (%.1f %%)
Murtoskeit: %d (%.1f %%)
Vahva alkusointu: %d (%.1f %%)
Pelkk heikko alkusointu: %d (%.1f %%)
MITVA-20: %d (eri setyyppej 20 sett kohti)
'''

rawsummary = '''lines:%d
err:%d
err-p:%.3f
warn:%d
warn-p:%.3f
broken:%d
broken-p:%.3f
a-all:%d
a-all-p:%.3f
b-all:%d
b-all-p:%.3f
c-all:%d
c-all-p:%.3f
d-all:%d
d-all-p:%.3f
strong-all:%d
strong-all-p:%.3f
weak-all:%d
weak-all-p:%.3f
mitva20:%d'''

class HtmlTemplate:
    pass

normal = HtmlTemplate()

# 1. content
normal.DOC = '''<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"
        "http://www.w3.org/TR/REC-html40/loose.dtd">
<html lang="fi">
<head>
<title>Trokeemankeli: tulokset</title>
<link rel="stylesheet" type="text/css" href="http://www.sci.fi/~alboin/trokeemankeli/mankeli.css">
</head>

<body>

<h1>Trokeemankeli: tulokset</h1>

%s

</body>
</html>
'''

# 1. table rows
normal.TABLE = '''<h2>Tulokset riveittin</h2>

<table>
<tr><th>#&nbsp;</th><th>Tulos&nbsp;</th><th>Muoto&nbsp;</th><th>Se&nbsp;</th></tr>\n
%s
</table>
'''

# 1. line number
# 2. status
# 3. form
# 4. line
# 5. comments
normal.ROW = '<tr><td>%s</td><td>%s</td><td>%s</td><td><span class=verse>%s</span> %s</td></tr>\n'

# 1., 2. line number (twice)
normal.COL_1 = '<a name="%s">%s</a>'

normal.COL_2_OK = 'OK'
normal.COL_2_WARN = '<em class=warning>Varoitus</em>'
normal.COL_2_ERR = '<strong class=error>Virhe</strong>'

# 1. syllable
normal.SYLL_ERR = '<strong class=error>%s</strong>'

# 1. list of comments
normal.COMMENT_LIST = '<ul class="comments">%s\n</ul>'

# 1. comment text
# 2. link to explanation (can be empty)
normal.COMMENT_ITEM = '\n<li>%s %s</li>'

# 1. number of lines
# 2. number of lines with errors
# 3. error percentage
# 4. number of lines with warnings (but no errors)
# 5. warning percentage
# 6. murtose percentage
normal.SUMMARY = '''<h2>Yhteenveto</h2>
<p>%d rivi, joista
%d (%.0f %%) virheellisi ja
%d (%.0f %%) varoituksen saaneita.
<span class=murto>Murtoskeit</span> %.0f %%.</p>
'''

# number of line types
normal.STATISTICS = '''<p>MITVA: %d eri setyyppi 20 sett kohden 
(Kalevalassa yleens noin 11).</p>
'''

# Differences from the template "normal": 
# - no SUMMARY
# - no STATISTICS
simple = HtmlTemplate()

simple.DOC = '''<html>
<head>
</head>
<body>

%s

</body>
</html>
'''

simple.TABLE = '''<table>
<tr><th>#&nbsp;</th><th>Tulos&nbsp;</th><th>Muoto&nbsp;</th><th>Se&nbsp;</th></tr>
%s
</table>
'''

simple.ROW = '<tr><td valign="top">%s</td><td valign="top">%s</td><td valign="top">%s</td><td valign="top">%s %s</td></tr>'

simple.COL_1 = '<a name="%s">%s</a>'

simple.COL_2_OK = 'OK'
simple.COL_2_WARN = '<i>Varoitus</i>'
simple.COL_2_ERR = '<b>Virhe</b>'

simple.SYLL_ERR = '<b>%s</b>'

simple.COMMENT_LIST = '%s'

simple.COMMENT_ITEM = '\n<br>%s'
