import analysis
import unittest

class TestGlobalStatistics(unittest.TestCase):

    def setUp(self):
        self.stat = analysis.GlobalStatistics()
        self.line = analysis.Line()
        self.res = analysis.AnalysisResult()
        
    def testAlliteration(self):
        self.res.alliterationTypes = ''
        self.stat.nextLine(self.line, self.res)
        self.stat.end()        
        self.assertEqual(0, self.stat.numStrongAlliteration())        
        self.assertEqual(0, self.stat.percentageStrongAlliteration())
        self.assertEqual(0, self.stat.numWeakAlliteration())
        self.assertEqual(0, self.stat.percentageWeakAlliteration())
        self.assertEqual(0, self.stat.numAlliteration('A'))
        self.assertEqual(0, self.stat.numAlliteration('B'))
        self.assertEqual(0, self.stat.numAlliteration('C'))
        self.assertEqual(0, self.stat.numAlliteration('D'))
        self.assertEqual(0, self.stat.percentageAlliteration('A'))
        self.assertEqual(0, self.stat.percentageAlliteration('B'))
        self.assertEqual(0, self.stat.percentageAlliteration('C'))
        self.assertEqual(0, self.stat.percentageAlliteration('D'))
    
    def testAlliteration2(self):
        self.res.alliterationTypes = 'A'
        self.stat.nextLine(self.line, self.res)
        self.res.alliterationTypes = 'B'
        self.stat.nextLine(self.line, self.res)
        self.res.alliterationTypes = 'C'
        self.stat.nextLine(self.line, self.res)        
        self.res.alliterationTypes = 'CD'
        self.stat.nextLine(self.line, self.res)
        self.res.alliterationTypes = 'BCD'
        self.stat.nextLine(self.line, self.res)
        self.stat.end()
        self.assertEqual(3, self.stat.numStrongAlliteration())        
        self.assertEqual(60, self.stat.percentageStrongAlliteration())
        self.assertEqual(2, self.stat.numWeakAlliteration())
        self.assertEqual(40, self.stat.percentageWeakAlliteration())
        self.assertEqual(1, self.stat.numAlliteration('A'))
        self.assertEqual(2, self.stat.numAlliteration('B'))
        self.assertEqual(3, self.stat.numAlliteration('C'))
        self.assertEqual(2, self.stat.numAlliteration('D'))
        self.assertEqual(20, self.stat.percentageAlliteration('A'))
        self.assertEqual(40, self.stat.percentageAlliteration('B'))
        self.assertEqual(60, self.stat.percentageAlliteration('C'))
        self.assertEqual(40, self.stat.percentageAlliteration('D'))
    
    def testBasic(self):
        self.res.warnings = {'heavy_beginning_w': 1}
        self.res.isBroken = True
        self.stat.nextLine(self.line, self.res)
        self.res.warnings = {'heavy_beginning_w': 1}
        self.res.generalErrors = {'short_rising': [3]}
        self.res.isBroken = False
        self.stat.nextLine(self.line, self.res)
        self.res.generalErrors = {'short_rising': [3]}
        self.res.isBroken = False
        self.stat.nextLine(self.line, self.res)
        self.stat.end()
        self.assertEqual(3, self.stat.numLines())
        self.assertEqual(2, self.stat.numError())
        self.assertAlmostEqual(66.66, self.stat.percentageError(), 1)
        self.assertEqual(1, self.stat.numWarning())
        self.assertAlmostEqual(33.33, self.stat.percentageWarning(), 1)
        self.assertEqual(1, self.stat.numBroken())
        self.assertAlmostEqual(33.33, self.stat.percentageBroken(), 1)
        