class AnalysisResult:

    def __init__(self):
        self.syllableErrors = {}
        self.syllableErrors['short_rising'] = []
        self.syllableErrors['long_falling'] = []
        self.generalErrors = {}
        self.warnings = {}
        self.notes = {}
        self.mainType = ''
        self.detailedType = ''
        self.syllableShapes = ''
        self.alliterationTypes = ''
        self.syllablesModified = False
        self.isBroken = False

    # 1-based index
    def syllableHasError(self, sIndex):
        for indices in self.syllableErrors.values():
            if sIndex in indices:
                return True
        return False
    
    def numErrors(self):
        num = 0
        for v in self.syllableErrors.values():
            num += len(v)
        return num + len(self.generalErrors.keys())
        
    def numWarnings(self):
        return len(self.warnings.keys())
    
class Line:

    def __init__(self):
        self.content = None

    def __str__(self):
        return str(self.content)

class GlobalStatistics:

    def __init__(self):
        self.numLines_ = 0
        self.types_ = []
        self.alliterationTypes_ = {}
        self.alliterationTypes_['A'] = 0
        self.alliterationTypes_['B'] = 0
        self.alliterationTypes_['C'] = 0
        self.alliterationTypes_['D'] = 0
        self.numStrongAlliteration_ = 0
        self.numWeakAlliteration_ = 0
        self.numError_ = 0
        self.numWarning_ = 0
        self.numBroken_ = 0
                
    def nextLine(self, line, result):
        self.numLines_ += 1
        self.types_.append(result.mainType)
        
        allit = result.alliterationTypes
        if 'A' in allit or 'B' in allit:
            self.numStrongAlliteration_ += 1
        elif 'C' in allit or 'D' in allit:
            self.numWeakAlliteration_ += 1
        for char in allit:
            self.alliterationTypes_[char] += 1
    
        if result.numErrors() > 0:
            self.numError_ += 1
        elif result.numWarnings() > 0:
            self.numWarning_ += 1
        
        if result.isBroken:
            self.numBroken_ += 1
                
    def end(self):
        pass
    
    def numLines(self):
        return self.numLines_
    
    def numStrongAlliteration(self):
        return self.numStrongAlliteration_

    def numWeakAlliteration(self):
        return self.numWeakAlliteration_
    
    def numAlliteration(self, allitType):
        return self.alliterationTypes_[allitType]
    
    def numError(self):
        return self.numError_
    
    def numWarning(self):    
        return self.numWarning_
    
    def numBroken(self):
        return self.numBroken_
    
    def metricalVariation(self, sampleSize):        
        if sampleSize > self.numLines_:
            return 0

        firstLine = 0
        lastLine = sampleSize - 1
        numTypes = []

        while lastLine < self.numLines_:
            numTypes.append(self.countTypes(self.types_, firstLine,
                                            lastLine))
            firstLine += 1
            lastLine += 1
            
        sum = 0
        for number in numTypes:
            sum += number
        return int(round(sum / float(len(numTypes))))

    def countTypes(self, types, first, last):
        found = {}
        for index in range(first, last + 1):
            found[types[index]] = 1
        return len(found)

    def percentageError(self):
        if self.numLines() > 0:
            return float(self.numError()) / self.numLines() * 100
        else:
            return 0.0

    def percentageWarning(self):
        if self.numLines() > 0:
            return float(self.numWarning()) / self.numLines() * 100
        else:
            return 0.0

    def percentageAlliteration(self, allitType):
        if self.numLines() > 0:
            return (float(self.alliterationTypes_[allitType]) 
                    / self.numLines() * 100)
        else:
            return 0.0
        
    def percentageStrongAlliteration(self):
        if self.numLines() > 0:
            return (float(self.numStrongAlliteration()) 
                    / self.numLines() * 100)
        else:
            return 0.0
    
    def percentageWeakAlliteration(self):
        if self.numLines() > 0:
            return (float(self.numWeakAlliteration()) 
                    / self.numLines() * 100)
        else:
            return 0.0
        
    def percentageBroken(self):
        if self.numLines() > 0:
            return (float(self.numBroken()) 
                    / self.numLines() * 100)
        else:
            return 0.0
        