# -*- coding: iso-8859-1 -*-

class Syllable:

    def __init__(self):
        self.phones = ''        

class Word:

    def __init__(self):
        self.syllables = []

    def getPhone(self, index):
        phonesBeforeThisSyllable = 0;

        for syl in self.syllables:
            if phonesBeforeThisSyllable + len(syl.phones) > index:
                break
            else:
                phonesBeforeThisSyllable += len(syl.phones)

        return syl.phones[index - phonesBeforeThisSyllable]

    def numPhones(self):
        sum = 0
        for syl in self.syllables:
            sum += len(syl.phones)
        return sum

class CompoundWord:

    def __init__(self):
        self.words = None
        
class Text:

    def __init__(self, text):
        self.compoundWords = []
        self.words = self.createWords(text)
        
    def __str__(self):
        cpdList = []
        for cpd in self.compoundWords:
            wordList = []
            for w in cpd.words:
                wordList.append('-'.join([x.phones for x in w.syllables]))
            cpdList.append('='.join(wordList))
        return ' '.join(cpdList)

    def getPhone(self, index):
        phonesBeforeThisWord = 0;

        for wd in self.words:
            if phonesBeforeThisWord + wd.numPhones() > index:
                break
            else:
                phonesBeforeThisWord += wd.numPhones()

        return wd.getPhone(index - phonesBeforeThisWord)

    def numPhones(self):
        sum = 0
        for wd in self.words:
            sum += wd.numPhones()
        return sum

    def getSyllable(self, index):
        sylsBeforeThisWord = 0

        for wd in self.words:
            if sylsBeforeThisWord + len(wd.syllables) > index:
                break
            else:
                sylsBeforeThisWord += len(wd.syllables)

        return wd.syllables[index - sylsBeforeThisWord]

    def numSyllables(self):
        sum = 0
        for wd in self.words:
            sum += len(wd.syllables)
        return sum

    def createWords(self, text):
        cpdStrings = text.split()
        wordObjects = []
        for cpdStr in cpdStrings:
            wordsInCpd = []
            for wordStr in cpdStr.split('='):
                wordObj = Word()
                wordObj.syllables = self.createSyllables(wordStr)
                wordObjects.append(wordObj)
                wordsInCpd.append(wordObj)
            cpd = CompoundWord()
            cpd.words = wordsInCpd    
            self.compoundWords.append(cpd)
        return wordObjects

    def createSyllables(self, text):
        syllableStrings = text.split('-')
        syllableObjects = []
        for syllableStr in syllableStrings:
            syllableObj = Syllable()
            syllableObj.phones = syllableStr
            syllableObjects.append(syllableObj)
        return syllableObjects
