import data.text
import data.analysis

class AnalyzerStrategy:

    def __init__(self, analyzer):
        self.analyzer = analyzer
    
    def analyzeLine(self, line, syllabifications, stats, observers):
        result = self.analyzer.validate(line)
        
        if result.numErrors() > 0:        
            line, result = self.tryDifferentSyllabifications(line, result,
                    syllabifications)
            
        stats.nextLine(line, result)
        for obs in observers:
            obs.lineProcessed(line, result)
        
    def tryDifferentSyllabifications(self, line, result, alternatives):
        for penalty, alt in alternatives:
            newLine = data.analysis.Line()
            newLine.content = data.text.Text(alt)
            newResult = self.analyzer.validate(newLine)
            
            lengthened = False
            num = line.content.numSyllables()
            if num > 7 \
            and newLine.content.numSyllables() > num:
                lengthened = True
                
            if newResult.numErrors() == 0 \
            and not lengthened:
            #and penalty < 15:
                newResult.syllablesModified = True
                newResult.notes['syllabification'] = 1
                return newLine, newResult
                
        return line, result