import engine.AnalyzerStrategy
import engine.analyze
import data.analysis
import data.text
import lang.Hyphenation
import config.lang
import config.ids
import main.TestDataReader
import unittest

class Fakistics:
    def nextLine(self, line, result):
        pass

class Fakeput:
    def lineProcessed(self, line, result):
        self.line = line
        #print str(line), line.content.numSyllables()    

class TestAnalyzerStrategy(unittest.TestCase):

    def setUp(self):
        self.hyph = lang.Hyphenation.Hyphenation(
                config.lang.vowels, 
                config.lang.consonants, 
                config.lang.diphNormal, 
                config.lang.diphSpecial, 
                config.lang.customLower, 
                config.lang.customUpper, 
                config.lang.inputPartSeparator, 
                config.lang.outputPartSeparator, 
                config.lang.outputSyllSeparator, 
                config.lang.syllShapes,
                config.ids.maxSyllabifications,
                config.ids.penalty)
        self.strategy = engine.AnalyzerStrategy.AnalyzerStrategy(
                engine.analyze.Analyzer(self.hyph))
        self.stat = Fakistics()
        self.output = Fakeput()
        
    def testModifySyllabification(self):        
        #self.__doSyllabificationTest('syllabification.txt')
        self.__doSyllabificationTest(
                [(0, 'ps-t kal-van Kau-ko-mi-e-len'),
                 (5, 'ps-t kal-van Ka-u-ko-mi-e-len'),
                 (10, 'p-st kal-van Kau-ko-mie-len'),
                 (15, 'p-st kal-van Ka-u-ko-mie-len')],
                'p-st kal-van Kau-ko-mie-len')

    def __doSyllabificationTest(self, input, expected):
        penalty, initial = input.pop(0)        
        line = data.analysis.Line()
        line.content = data.text.Text(initial)
            
        self.strategy.analyzeLine(line, input, self.stat, 
                                  [self.output])
            
        self.assertEqual(expected, str(self.output.line))
            
    def __doSyllabificationTest2(self, testFile):
        reader = main.TestDataReader.TestDataReader(
                'engine/testdata/' + testFile)
        testData = reader.getPairs()

        for input, expected in testData:
            line = data.analysis.Line()
            line.content = data.text.Text(input)
            
            self.strategy.analyzeLine(line, self.stat, [self.output])
            
            self.assertEqual(expected, str(self.output.line))