# -*- coding: iso-8859-1 -*-

import uicommon.document
import cli.HtmlOutput
import config.text
import wx
import wx.html
import StringIO

class MyFrame(wx.Frame):
    def __init__(self, parent, title):
        wx.Frame.__init__(self, parent, -1, title,
                          pos=(150, 150), size=(600, 400))

        # Create the menubar
        menuBar = wx.MenuBar()

        # and a menu 
        menu = wx.Menu()

        # add an item to the menu, using \tKeyName automatically
        # creates an accelerator, the third param is some help text
        # that will show up in the statusbar
        menu.Append(wx.ID_EXIT, "Lopeta\tAlt-X", "")

        # bind the menu event to an event handler
        self.Bind(wx.EVT_MENU, self.OnTimeToClose, id=wx.ID_EXIT)

        # and put the menu on the menubar
        menuBar.Append(menu, "&Tiedosto")
        self.SetMenuBar(menuBar)

        self.CreateStatusBar()
        
        tb = self.CreateToolBar(wx.TB_HORIZONTAL
            | wx.NO_BORDER
            | wx.TB_FLAT)
        button = wx.Button(tb, 10, 'Tarkasta', (20, 20))    
        tb.AddControl(button)
        self.Bind(wx.EVT_BUTTON, self.OnCheckButton, button)
        tb.Realize()
        
        splitter = wx.SplitterWindow(self, style=wx.NO_3D|wx.SP_3D)
        splitter.SetMinimumPaneSize(1)

        self.textBox = wx.TextCtrl(splitter, style=wx.TE_MULTILINE)
        self.html = wx.html.HtmlWindow(splitter)
     
        splitter.SplitVertically(self.textBox, self.html)
        splitter.SetSashPosition(180, True)        

    def OnTimeToClose(self, evt):
        self.Close()

    def OnCheckButton(self, evt):
        self.resultString = StringIO.StringIO('')
        doc = uicommon.document.Document(self.GetInput(), 
                                         [self.GetOutput()])
        doc.analyze()

        self.html.SetPage(self.resultString.getvalue())

    def GetInput(self):
        unicodeStr = self.textBox.GetValue()
        encodedStr = unicodeStr.encode('latin_1', 'replace')
        return StringIO.StringIO(encodedStr)
        
    def GetOutput(self):
        output = cli.HtmlOutput.HtmlOutput(self.resultString)
        output.setShortMode(config.text.simple)
        return output

class MyApp(wx.App):
    def OnInit(self):
        frame = MyFrame(None, "KaRuSen Trokeemankeli")
        self.SetTopWindow(frame)

        frame.Show(True)
        return True
