import lang.TestHyphenation
import data.TestText
import data.TestGlobalStatistics
import engine.TestPreprocessor
import engine.TestAnalyzer
import engine.TestAnalyzerStrategy
import TestFunctional
import unittest

class MainTestSuite(unittest.TestSuite):

    def __init__(self):
        unittest.TestSuite.__init__(self)
        self.addTest(unittest.makeSuite(
                data.TestText.TestText, 'test'))
        self.addTest(unittest.makeSuite(
                data.TestGlobalStatistics.TestGlobalStatistics, 'test'))
        self.addTest(unittest.makeSuite(
                lang.TestHyphenation.TestHyphenation, 'test'))
        self.addTest(unittest.makeSuite(
                engine.TestPreprocessor.TestPreprocessor, 'test'))
        self.addTest(unittest.makeSuite(
                engine.TestAnalyzer.TestAnalyzer, 'test'))
        self.addTest(unittest.makeSuite(
                engine.TestAnalyzerStrategy.TestAnalyzerStrategy, 'test'))
        self.addTest(unittest.makeSuite(
                TestFunctional.TestFunctional, 'test'))

if __name__ == "__main__":
    suite = MainTestSuite()
    unittest.TextTestRunner().run(suite)
