# -*- coding: iso-8859-1 -*-

import popen2
import unittest

class TestFunctional(unittest.TestCase):
    
    doc = [
("""python trokeemankeli.py -i "Yksi, kaksi, kolme, nelj" """,
"""1 OK Yk-si kak-si kol-me nel-j
"""),

("""python trokeemankeli.py -i "Vinminen, Vinminen! / Miksi oot sie Vinminen?" """,
"""1 OK Vi-n-mi-nen Vi-n-mi-nen
2 OK Mik-si oot sie Vi-n-mi-nen
"""),

("""python trokeemankeli.py -i "kerrostalon kellarissa" """,
"""1 OK ker-ros-ta-lon kel-la-ris-sa
"""),

("""python trokeemankeli.py -i "kerros-talon kellarissa" """,
"""1 Virhe ker-ros=ta-lon kel-la-ris-sa
\tVirhe: Lyhyt alkutavu runojalan nousussa. (ta)
"""),

("""python trokeemankeli.py -i " *** / Kypelit tuvilla Tuonen / *** " """,
"""1 OK Ky-pe-lit tu-vil-la Tuo-nen
"""),

("""python trokeemankeli.py -ri "Lenti it, lenti lnnet" """,
"""2|2222|PlLpPlPp|ikljikii|Len-ti i-t len-ti ln-net|short_rising=3||AC|0|0
"""),

("""python trokeemankeli.py -ri "a" """,
"""2|1|L|l|a||too_short||0|0
""")]

    other = [
("""python trokeemankeli.py -i "Paljo on tiiralla huolta" """,
"""1 Virhe Pal-jo on tii-ral-la huol-ta
\tVirhe: Pitk alkutavu runojalan laskussa. (tii)
"""),

("""python trokeemankeli.py -i "Paljo on tiiralla huolta" """,
"""1 Virhe Pal-jo on tii-ral-la huol-ta
\tVirhe: Pitk alkutavu runojalan laskussa. (tii)
"""),

("""python trokeemankeli.py -i "Paljo on tikalla ht" """,
"""1 Virhe Pal-jo on ti-kal-la h-t
\tVirhe: Lyhyt alkutavu runojalan nousussa. (h)
"""),

("""python trokeemankeli.py -i "Paljo on tikallaki, on" """,
"""1 Virhe Pal-jo on ti-kal-la-ki on
\tVirhe: Yksitavuinen sana skeen lopussa.
"""),

("""python trokeemankeli.py -i "Paljo tikkojenki huolta" """,
"""1 Virhe Pal-jo tik-ko-jen-ki huol-ta
\tVirhe: Nelitavuinen sana tasaskeen keskell (kesuura puuttuu).
"""),

("""python trokeemankeli.py -i "Paljo on tikalla huolii" """,
"""1 Virhe Pal-jo on ti-kal-la huo-lii
\tVirhe: Pitk vokaali viimeisess tavussa.
"""),

("""python trokeemankeli.py -i "Ai paljon on tikalla huolta" """,
"""1 Varoitus Ai pal-jon on ti-kal-la huol-ta
\tVaroitus: Raskas alku 9-tavuisessa skeess: kolme pitk tavua skeen alussa.
\t(Huom: yhdeksntavuinen.)
"""),

("""python trokeemankeli.py -i "Joo kaameet on tikalla huolet" """,
"""1 Virhe Joo kaa-meet on ti-kal-la huo-let
\tVirhe: Raskas alku 9-tavuisessa skeess: pitk vokaali kolmessa ensimmisess tavussa.
\t(Huom: yhdeksntavuinen.)
"""),

("""python trokeemankeli.py -i "Pal on tikalla huolta" """,
"""1 Virhe Pal on ti-kal-la huol-ta
\tVirhe: Alle kahdeksan tavua.
"""),

("""python trokeemankeli.py -i "Superpaljonko on tikalla huolta" """,
"""1 Virhe Su-per-pal-jon-ko on ti-kal-la huol-ta
\tVirhe: Yli kymmenen tavua.
""")]
    
    text = """Ne varsin valehtelevat,
Tuiki tyhje panevat,
Jotka soittoa sanovat,
Arvelevat kanteletta
Vinmisen veistmksi,
Jumalan kuvoamaksi,
Hauin suuren hartioista,
Veen koiran koukkuluista;
Soitto on suruista tehty,
Murehista muovaeltu:
Koppa pivist kovista,
Empuu ikipoloista,
Kielet kiusoista kertty,
Naulat muista vastuksista.
Sent ei soita kanteleni,
Ei iloitse ensinkn,
Soitto ei soita suosioksi,
Laske ei laatuista iloa,
Kun on huolista kuvattu,
Murehista muovaeltu.

Otettiin minusta outo,
Varsin virhi viskattihin,"""

    stat = ('python trokeemankeli.py -si "%s"',
"""Rivej: 22
Tulkittu virheelliseksi: 0 (0.0 %)
Pelkk varoitus: 0 (0.0 %)
Murtoskeit: 13 (59.1 %)
Vahva alkusointu: 13 (59.1 %)
Pelkk heikko alkusointu: 6 (27.3 %)
MITVA-20: 10 (eri setyyppej 20 sett kohti)
""")
    
    def testDocumentationExamples(self):
        self.doTest(self.doc)
    
    def testOther(self):
        self.doTest(self.other)
    
    def testStatistics(self):
        input = self.text.replace('\n', '/')
        self.doTest([(self.stat[0] % input, self.stat[1])])
            
    def doTest(self, data):    
        for command, expected in data:
            childOut, childIn, childErr = popen2.popen3(command)
            output = childOut.read()
            print childErr.read()
            childOut.close()
            childErr.close()
            childIn.close()
            self.assertEqual(expected, output)

if __name__ == "__main__":
    unittest.main()
