import cli.HtmlOutput

import cli.TextOutput
import cli.RawOutput
import config.ids
import config.text
import getopt
import sys

import StringIO

class ArgumentHandler:

    def __init__(self, allArguments):
        acceptedOptions = ''
        acceptedOptions += config.ids.arg_file_type
        acceptedOptions += config.ids.arg_input_type
        acceptedOptions += config.ids.arg_raw_type
        acceptedOptions += config.ids.arg_html_type
        acceptedOptions += config.ids.arg_summary_type
        acceptedOptions += config.ids.arg_raw_summary_type
        acceptedLongOptions = []
        acceptedLongOptions.append(config.ids.arg_file_long_type)
        acceptedLongOptions.append(config.ids.arg_input_long_type)
        acceptedLongOptions.append(config.ids.arg_raw_long_type)
        acceptedLongOptions.append(config.ids.arg_html_long_type)
        acceptedLongOptions.append(config.ids.arg_summary_long_type)
        acceptedLongOptions.append(config.ids.arg_raw_summary_long_type)
        inputFlag = False
        outputFlag = False

        self.output = cli.TextOutput.TextOutput(sys.stdout)
        
        try:
            opts, args = getopt.getopt(allArguments, acceptedOptions,
                                       acceptedLongOptions)
        except getopt.GetoptError:
            self.__usage()
            sys.exit(1)
            
        for o, a in opts:
            if o in ('-' + config.ids.arg_file,
                       '--' + config.ids.arg_file_long):
                if inputFlag:
                    print config.text.error_many_sources
                    self.__usage()
                    sys.exit(1)
                else:
                    self.input = open(a, 'r')
                    inputFlag = True

            elif o in ('-' + config.ids.arg_input,
                       '--' + config.ids.arg_input_long):
                if inputFlag:
                    print config.text.error_many_sources
                    self.__usage()
                    sys.exit(1)
                else:
                    self.input = StringIO.StringIO(a)
                    inputFlag = True
                    
            elif o in ('-' + config.ids.arg_raw,
                       '--' + config.ids.arg_raw_long):
                if outputFlag:
                    print config.text.error_many_outputs
                    self.__usage()
                    sys.exit(1)
                else:
                    self.output = cli.RawOutput.RawOutput(sys.stdout)
                    outputFlag = True

            elif o in ('-' + config.ids.arg_html,
                       '--' + config.ids.arg_html_long):    
                if outputFlag:
                    print config.text.error_many_outputs
                    self.__usage()
                    sys.exit(1)
                else:
                    self.output = cli.HtmlOutput.HtmlOutput(sys.stdout)
                    self.output.setLongMode(config.text.normal)
                    outputFlag = True
            elif o in ('-' + config.ids.arg_summary,
                       '--' + config.ids.arg_summary_long):
                if outputFlag:
                    print config.text.error_many_outputs
                    self.__usage()
                    sys.exit(1)
                else:
                    self.output.setMode('summary')
                    outputFlag = True
            elif o in ('-' + config.ids.arg_raw_summary,
                       '--' + config.ids.arg_raw_summary_long):
                if outputFlag:
                    print config.text.error_many_outputs
                    self.__usage()
                    sys.exit(1)
                else:
                    self.output.setMode('rawsummary')
                    outputFlag = True
                            
        if not inputFlag:
            self.input = sys.stdin

    def getInput(self):
        return self.input

    def getOutput(self):
        return self.output
        
    def __usage(self):
        print config.text.usage
