import engine.analyze
import engine.Preprocessor
import data.text
import data.analysis
import lang.Hyphenation
import config.lang
import config.ids

class Document:

    def __init__(self, theFile, observers):
        self.hyph = lang.Hyphenation.Hyphenation(
                config.lang.vowels, 
                config.lang.consonants, 
                config.lang.diphNormal, 
                config.lang.diphSpecial, 
                config.lang.customLower, 
                config.lang.customUpper, 
                config.lang.inputPartSeparator, 
                config.lang.outputPartSeparator, 
                config.lang.outputSyllSeparator, 
                config.lang.syllShapes,
                config.ids.maxSyllabifications,
                config.ids.penalty)
        self.analyzer = engine.analyze.Analyzer(self.hyph)
        self.processor = engine.Preprocessor.Preprocessor(
                self.hyph,
                config.lang.conversions,
                config.ids.maxLineLength)
        self.theFile = theFile
        self.observers = observers
        
        #self.parser = engine.analyze.InputParser()        

    def analyze(self):
        stats = data.analysis.GlobalStatistics()
        
        for obs in self.observers:
            obs.begin()
        for rawLine in self.theFile:
            preProcessedLines = self.processor.process(rawLine)
            # One input line can contain zero, one, or many lines 
            # (separated by '/')
            for lineStr in preProcessedLines:
                hyphenations = self.hyph.allHyphenations(lineStr)
                default = hyphenations.pop(0)
                line = data.analysis.Line()
                line.content = data.text.Text(default[1])
                #line = self.parser.parseLine(hyphenated)
                if line != None:
                    self.analyzer.analyzeLine(line, hyphenations, stats,
                                              self.observers)
        stats.end()
        for obs in self.observers:
            obs.end(stats)
